struct VSPos
{
	float3 Pos		: Position;
	float2 offset		: TexCoord;
};

struct VSOutput
{
	float4 Pos		: SV_Position;
	float4 ColorD		: COLOR0;
	float4 ClipplaneDist0 	: SV_ClipDistance0;    //clip distance for 4 planes
	float4 ClipplaneDist1 	: SV_ClipDistance1;    //clip distance for 4 planes
};
cbuffer cbPerObject
{
	bool g_bClippingEnable	: ClippingEnabled = false;
	int g_numClipplane	: clippingplanecount = 0;
	float4 g_clipplanes[8]	: clippingplanes;
	float4 g_Emissive	: EmissiveColor;						
};
cbuffer cbPerFrame
{
	float4x4 g_matViewProjIT		: viewprojectioninversetranspose;
	//wvp transform
	float4x4 g_matWorldViewProj		: WorldViewProjection;
	float2		g_ViewPort			: viewportpixelsize;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input)
{
	//Generate specific vertex data for marker
	VSOutput Out = (VSOutput) 0;
	
	//project vertex in model space to clipping space
	float4 LocalPos = float4(Input.Pos.xyz,1.0f);
	float4 outpos = mul(LocalPos,g_matWorldViewProj);
	
	//Perspective divide
	outpos.xyz /= outpos.w;
	outpos.w = 1.0f;
	
	//the vertex index is saved in alpha channel of each vertex
	outpos.xy += Input.offset/g_ViewPort;
	Out.Pos = outpos;
	
	Out.ColorD = g_Emissive;
	 
	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if(g_bClippingEnable)
	{	
		float dist[8] = {1,1,1,1,1,1,1,1};
		for(int i=0;i<g_numClipplane;i++)
		{
			float4 clippingPlane=mul(g_clipplanes[i],g_matViewProjIT);
			float len=length(clippingPlane.xyz);
			if(len!=0)
			{
				float dlen=1.0f/len;
				float4 normalizeClippingPlane=clippingPlane*dlen;
				dist[i] = dot( LocalPos,normalizeClippingPlane);
			}
		}
		Out.ClipplaneDist0.x = dist[0];
		Out.ClipplaneDist0.y = dist[1];
		Out.ClipplaneDist0.z = dist[2];
		Out.ClipplaneDist0.w = dist[3];
		Out.ClipplaneDist1.x = dist[4];
		Out.ClipplaneDist1.y = dist[5];
		Out.ClipplaneDist1.z = dist[6];
		Out.ClipplaneDist1.w = dist[7];
	}
	return Out;
}
float4 PS_Pos( VSOutput Input ) : SV_Target
{
	float4 Color = saturate(Input.ColorD);
	return Color;
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosTex
{
    pass P0
    {   
	SetVertexShader(CompileShader(vs_4_0,VS_Pos()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_Pos()) );
    }
}